{**********************************************************************
{*
{* BusyBox uEvent -- Version 3.0  (interface)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the interface to the code which implements the 
{* main event loop used by the busybox program.
{*
{**********************************************************************}

UNIT uEvent;

INTERFACE

USES
       types,
       GSOS,
       memory,
       locator,
       quickdraw,
       events,
       resources,
       controls,
       windows,
       lineedit,
       dialogs,
       menus,
       stdfile,
       IntMath,
       Fonts,
       Desk,

       uGlobals,
       uUtils,
       uWindow,
       uMenu;



procedure MainEvent;   {Main event handling loop which repeats until Quit}

IMPLEMENTATION

{$R-}

var
    LastWindow   : GrafPortPtr;         { This private global is used in CheckFrontW.
                                        { to prevent extra work when the windows
                                        { have not changed.  It is initialized
                                        { at the beginning of MainEvent. }




{*******************************************************************}
{
{ DoControls
{
{ This procedure is called when an inControl message is returned
{ by TaskMaster.
{
{ When this routine gets control, the ID of the control that was
{ hit is in TaskDATA4.  The control handle is in TaskData2 and
{ the part code is in taskData 3.
{
{*******************************************************************}
procedure DoControls;
var
    TheID : integer;
begin
    TheID := Event.wmTaskData4;
    if (ButButtonsID <= TheID) and (TheID <= Prog6ID) then
        OpenThisWindow(TheID);
end;



{*******************************************************************}
{
{ CheckFrontW
{
{ This routine checks the front window to see if any changes need
{ to be made to the menu items.
{
{ We do this so that the edit items are only active when a desk
{ accessory is active.
{
{*******************************************************************}
procedure CheckFrontW;

var 
    theWindow    : GrafPortPtr;

begin   {of CheckFrontW}
    { Get the front window into local storage.}
    theWindow := FrontWindow;
    
    { If the LastWindow is this window, we are all set. }
    if theWindow = lastWindow then Exit(CheckFrontW);
    
    { If there are no windows, everything should be disabled }
    if theWindow = nil then 
        begin
            SetMenuFlag ($0080,EditMenuID);
            DrawMenuBar;
        end 
    else
        begin
            { Otherwise we look at the window and see what to do. }
            if GetSysWFlag (theWindow) <> false then 
                begin   {Set up for da windows}
                    SetMenuFlag ($FF7F,EditMenuID);
                    DrawMenuBar;
                end
            else
                begin   {Set up for our windows}
                    SetMenuFlag ($0080,EditMenuID);
                    DrawMenuBar;
                end;
        end;
    
    { Remember this for next time. }
    lastWindow := theWindow;
end;    {of CheckFrontW}





{************************************************************************
{
{ MainEvent
{
{ This is the main part of the program.  The program cycles in this
{ loop until the user choose select.
{
{************************************************************************}
procedure MainEvent;


var 
    code : integer;


begin   {of MainEvent}
   Event.wmTaskMask := $001FFFFF;       { Allow TaskMaster to do everything. }
   Done             := false;           { Done flag will be set by Quit item. }
   LastWindow       := NIL;             { Init this for CheckFrontW. }

   repeat
       CheckFrontW;
       code := TaskMaster ($FFFF,Event);
       case code of
           wInGoAway    : DoCloseTop;
           wInSpecial,
           wInMenuBar   : DoMenu;
           wInControl   : DoControls;
       end;
   until Done;
end;    {of MainEvent}


END.
